<?php
require_once '../config/database.php';
require_once '../config/session.php';

if (!isLoggedIn()) {
    echo json_encode(['success' => false, 'message' => 'Not logged in']);
    exit();
}

header('Content-Type: application/json');

$department = $_GET['department'] ?? 'all';

try {
    $sql = "SELECT id, full_name, department, salary, allowance FROM employees WHERE 1=1";
    $params = [];
    
    if ($department != 'all') {
        $sql .= " AND department = ?";
        $params[] = $department;
    }
    
    $sql .= " ORDER BY full_name";
    
    $stmt = $pdo->prepare($sql);
    $stmt->execute($params);
    $employees = $stmt->fetchAll();
    
    echo json_encode([
        'success' => true,
        'employees' => $employees
    ]);
    
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'message' => 'Error: ' . $e->getMessage()
    ]);
}
?>