<?php
// Get user role
$user_role = $_SESSION['role'] ?? 'employee';
$full_name = $_SESSION['full_name'] ?? 'User';
$department = $_SESSION['department'] ?? '';

// Get pending approvals count for admin
$pending_count = 0;
if ($user_role === 'admin') {
    require_once 'config/database.php';
    try {
        $stmt = $pdo->query("SELECT COUNT(*) as count FROM users WHERE is_active = 0 AND role = 'employee'");
        $result = $stmt->fetch();
        $pending_count = $result['count'];
    } catch (Exception $e) {
        // Silently fail if database error
        error_log("Error getting pending count: " . $e->getMessage());
    }
}
?>

<div class="bg-dark text-white" id="sidebar-wrapper" style="width: 300px; min-height: 100vh;">
    <div class="sidebar-heading p-4">
        <h5>HR System</h5>
        <div class="user-info mt-3">
            <div class="d-flex align-items-center">
                <div class="rounded-circle bg-primary d-flex align-items-center justify-content-center" 
                     style="width: 40px; height: 40px;">
                    <span class="text-white"><?php echo strtoupper(substr($full_name, 0, 1)); ?></span>
                </div>
                <div class="ms-3">
                    <h6 class="mb-0"><?php echo htmlspecialchars($full_name); ?></h6>
                    <small class="text-light">
                        <span class="badge 
                            <?php 
                            echo $user_role == 'admin' ? 'bg-danger' : 
                                 ($user_role == 'manager' ? 'bg-warning' : 'bg-success'); 
                            ?>">
                            <?php echo ucfirst($user_role); ?>
                        </span>
                        <?php if($department): ?>
                            <br><small><?php echo htmlspecialchars($department); ?></small>
                        <?php endif; ?>
                    </small>
                </div>
            </div>
        </div>
    </div>
    
    <div class="list-group list-group-flush">
        <!-- Dashboard - All roles -->
        <a href="dashboard.php" class="list-group-item list-group-item-action bg-dark text-white <?php echo (!isset($_GET['page']) || $_GET['page'] == 'overview') ? 'active' : ''; ?>">
            <i class="bi bi-speedometer2 me-2"></i> Dashboard
        </a>
        
        <!-- Employee Management - Admin & Manager only -->
        <?php if(hasPermission('manage_employees') || $user_role === 'admin'): ?>
        <a href="dashboard.php?page=employees" class="list-group-item list-group-item-action bg-dark text-white <?php echo (isset($_GET['page']) && $_GET['page'] == 'employees') ? 'active' : ''; ?>">
            <i class="bi bi-people me-2"></i> Employee Profiles
        </a>
        <?php endif; ?>
        
        <!-- Attendance - All roles -->
        <?php if(hasPermission('view_attendance')): ?>
        <a href="dashboard.php?page=attendance" class="list-group-item list-group-item-action bg-dark text-white <?php echo (isset($_GET['page']) && $_GET['page'] == 'attendance') ? 'active' : ''; ?>">
            <i class="bi bi-calendar-check me-2"></i> Attendance
        </a>
        <?php endif; ?>
        
        <!-- Leave Management - All roles -->
        <?php if(hasPermission('apply_leaves')): ?>
        <a href="dashboard.php?page=leave" class="list-group-item list-group-item-action bg-dark text-white <?php echo (isset($_GET['page']) && $_GET['page'] == 'leave') ? 'active' : ''; ?>">
            <i class="bi bi-calendar-event me-2"></i> Leave Management
        </a>
        <?php endif; ?>
        
        <!-- Salary Management - Admin & Manager only -->
        <?php if($user_role === 'admin' || hasPermission('manage_salary')): ?>
        <a href="dashboard.php?page=salary_update" class="list-group-item list-group-item-action bg-dark text-white <?php echo (isset($_GET['page']) && $_GET['page'] == 'salary_update') ? 'active' : ''; ?>">
            <i class="bi bi-cash-coin me-2"></i> Salary Management
        </a>
        <?php endif; ?>
        
        <!-- Intern Management - Admin & Manager only -->
        <?php if(hasPermission('manage_interns') || $user_role === 'admin'): ?>
        <a href="dashboard.php?page=interns" class="list-group-item list-group-item-action bg-dark text-white <?php echo (isset($_GET['page']) && $_GET['page'] == 'interns') ? 'active' : ''; ?>">
            <i class="bi bi-person-badge me-2"></i> Intern Management
        </a>
        <?php endif; ?>
        
        <!-- Reports - Admin & Manager only -->
        <?php if(hasPermission('view_reports') || $user_role === 'admin'): ?>
        <a href="dashboard.php?page=reports" class="list-group-item list-group-item-action bg-dark text-white <?php echo (isset($_GET['page']) && $_GET['page'] == 'reports') ? 'active' : ''; ?>">
            <i class="bi bi-graph-up me-2"></i> Reports & Analytics
        </a>
        <?php endif; ?>
        
        <!-- Pending Approvals - Admin only -->
        <?php if($user_role === 'admin' && $pending_count > 0): ?>
        <a href="dashboard.php?page=pending_approvals" class="list-group-item list-group-item-action bg-dark text-warning <?php echo (isset($_GET['page']) && $_GET['page'] == 'pending_approvals') ? 'active' : ''; ?>">
            <i class="bi bi-person-check me-2"></i> Pending Approvals
            <span class="badge bg-warning float-end"><?php echo $pending_count; ?></span>
        </a>
        <?php endif; ?>
        
        <!-- User Management - Admin only -->
        <?php if(hasPermission('manage_users') || $user_role === 'admin'): ?>
        <a href="dashboard.php?page=users" class="list-group-item list-group-item-action bg-dark text-white <?php echo (isset($_GET['page']) && $_GET['page'] == 'users') ? 'active' : ''; ?>">
            <i class="bi bi-person-lines-fill me-2"></i> User Management
        </a>
        <?php endif; ?>
        
        <!-- Departments - Admin only -->
        <?php if(hasPermission('manage_departments') || $user_role === 'admin'): ?>
        <a href="dashboard.php?page=departments" class="list-group-item list-group-item-action bg-dark text-white <?php echo (isset($_GET['page']) && $_GET['page'] == 'departments') ? 'active' : ''; ?>">
            <i class="bi bi-building me-2"></i> Departments
        </a>
        <?php endif; ?>
        
        <!-- My Profile - All roles -->
        <a href="dashboard.php?page=profile" class="list-group-item list-group-item-action bg-dark text-white <?php echo (isset($_GET['page']) && $_GET['page'] == 'profile') ? 'active' : ''; ?>">
            <i class="bi bi-person-circle me-2"></i> My Profile
        </a>
        
        <!-- Settings - Admin only -->
        <?php if($user_role === 'admin'): ?>
        <a href="dashboard.php?page=settings" class="list-group-item list-group-item-action bg-dark text-white <?php echo (isset($_GET['page']) && $_GET['page'] == 'settings') ? 'active' : ''; ?>">
            <i class="bi bi-gear me-2"></i> Settings
        </a>
        <?php endif; ?>
        
        <!-- Registration Link for All Roles -->
        <?php if($user_role !== 'admin'): ?>
        <a href="register.php" class="list-group-item list-group-item-action bg-dark text-info">
            <i class="bi bi-person-plus me-2"></i> Register New Employee
        </a>
        <?php endif; ?>
        
        <div class="mt-auto">
            <a href="logout.php" class="list-group-item list-group-item-action bg-dark text-danger">
                <i class="bi bi-box-arrow-right me-2"></i> Logout
            </a>
        </div>
    </div>
</div>

<style>
.list-group-item.active {
    background-color: #0d6efd !important;
    border-color: #0d6efd !important;
    color: white !important;
}
.list-group-item:hover:not(.active) {
    background-color: #343a40 !important;
    color: white !important;
}
</style>