<?php
redirectIfNotLoggedIn();

// Get employee's leave balance
$employee_id = $_SESSION['user_id'];
$stmt = $pdo->prepare("SELECT * FROM leave_balance WHERE employee_id = ?");
$stmt->execute([$employee_id]);
$balance = $stmt->fetch();
?>

<div class="card">
    <div class="card-header">
        <h5 class="mb-0">Leave Balance Details</h5>
    </div>
    <div class="card-body">
        <?php if($balance): ?>
        <div class="row">
            <div class="col-md-4">
                <div class="card text-white bg-success mb-3">
                    <div class="card-body text-center">
                        <h4><?php echo $balance['casual_leaves'] - $balance['used_casual']; ?></h4>
                        <p class="mb-0">Casual Leave Available</p>
                        <small><?php echo $balance['used_casual']; ?> used of <?php echo $balance['casual_leaves']; ?> total</small>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="card text-white bg-info mb-3">
                    <div class="card-body text-center">
                        <h4><?php echo $balance['sick_leaves'] - $balance['used_sick']; ?></h4>
                        <p class="mb-0">Sick Leave Available</p>
                        <small><?php echo $balance['used_sick']; ?> used of <?php echo $balance['sick_leaves']; ?> total</small>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="card text-white bg-warning mb-3">
                    <div class="card-body text-center">
                        <h4><?php echo $balance['annual_leaves'] - $balance['used_annual']; ?></h4>
                        <p class="mb-0">Annual Leave Available</p>
                        <small><?php echo $balance['used_annual']; ?> used of <?php echo $balance['annual_leaves']; ?> total</small>
                    </div>
                </div>
            </div>
        </div>
        <?php else: ?>
        <p class="text-muted">No leave balance information found.</p>
        <?php endif; ?>
    </div>
</div>